---
generated_at: 2026-01-27 10:50:00
metrics:
  claims_total: 28
  claims_with_evidence: 27
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：5-User Data Profile Export/Import

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：27 / 28、根拠なし：1
- 優先レビュー（高）
  1. **目標出力時間**：明示的な定義なし

## 2) 参照した情報（Evidence一覧）

- E-01: `src/vs/workbench/services/userDataProfile/browser/userDataProfileImportExportService.ts` - IUserDataProfileTemplate (行44-53)
- E-02: `src/vs/workbench/services/userDataProfile/browser/userDataProfileImportExportService.ts` - isUserDataProfileTemplate() (行55-64)
- E-03: `src/vs/workbench/services/userDataProfile/browser/userDataProfileImportExportService.ts` - exportProfile() (行222-230)
- E-04: `src/vs/workbench/services/userDataProfile/browser/userDataProfileImportExportService.ts` - doExportProfile() (行256-317)
- E-05: `src/vs/workbench/services/userDataProfile/browser/userDataProfileImportExportService.ts` - resolveProfileTemplate() (行319-370)
- E-06: `src/vs/workbench/services/userDataProfile/browser/userDataProfileImportExportService.ts` - resolveProfileContent() (行406-442)
- E-07: `src/vs/workbench/services/userDataProfile/browser/userDataProfileImportExportService.ts` - applyProfileTemplate() (行180-220)
- E-08: `src/vs/workbench/services/userDataProfile/browser/userDataProfileImportExportService.ts` - getProfileTemplate() (行609-646)
- E-09: `src/vs/workbench/services/userDataProfile/browser/userDataProfileImportExportService.ts` - FileUserDataProfileContentHandler (行495-543)
- E-10: `src/vs/workbench/services/userDataProfile/browser/userDataProfileImportExportService.ts` - getProfileToImport() (行461-491)
- E-11: `src/vs/workbench/services/userDataProfile/common/userDataProfile.ts` - PROFILE_EXTENSION, PROFILE_FILTER

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | IUserDataProfileTemplateにname必須 | E-01, E-02 (行59) | ○ |
| C-02 | IUserDataProfileTemplateにicon任意 | E-01 (行47) | ○ |
| C-03 | IUserDataProfileTemplateにsettings任意 | E-01 (行48) | ○ |
| C-04 | IUserDataProfileTemplateにkeybindings任意 | E-01 (行49) | ○ |
| C-05 | IUserDataProfileTemplateにtasks任意 | E-01 (行50) | ○ |
| C-06 | IUserDataProfileTemplateにsnippets任意 | E-01 (行51) | ○ |
| C-07 | IUserDataProfileTemplateにglobalState任意 | E-01 (行52) | ○ |
| C-08 | IUserDataProfileTemplateにextensions任意 | E-01 (行53) | ○ |
| C-09 | isUserDataProfileTemplateで検証 | E-02 | ○ |
| C-10 | exportProfile()がエクスポートのエントリーポイント | E-03 | ○ |
| C-11 | doExportProfile()でContentHandler選択 | E-04 (行269-276) | ○ |
| C-12 | saveProfile()でファイル保存 | E-04 (行277) | ○ |
| C-13 | resolveProfileTemplate()でインポート処理 | E-05 | ○ |
| C-14 | JSON.parseでパース | E-05 (行328) | ○ |
| C-15 | 不正プロファイルでエラー | E-05 (行330, 335) | ○ |
| C-16 | resolveProfileContent()でコンテンツ取得 | E-06 | ○ |
| C-17 | HTTP GET for URL content | E-06 (行435-441) | ○ |
| C-18 | applyProfileTemplate()で各リソース適用 | E-07 | ○ |
| C-19 | SettingsResourceのapply | E-07 (行183) | ○ |
| C-20 | KeybindingsResourceのapply | E-07 (行189-190) | ○ |
| C-21 | TasksResourceのapply | E-07 (行195-197) | ○ |
| C-22 | SnippetsResourceのapply | E-07 (行202-204) | ○ |
| C-23 | GlobalStateResourceのapply | E-07 (行209-211) | ○ |
| C-24 | ExtensionsResourceのapply | E-07 (行216-218) | ○ |
| C-25 | getProfileTemplate()で各リソース収集 | E-08 | ○ |
| C-26 | FileUserDataProfileContentHandlerでLocal保存 | E-09 | ○ |
| C-27 | 同名プロファイル確認ダイアログ | E-10 (行467-475) | ○ |
| C-28 | 目標出力時間5秒以内 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件（目標出力時間）は実装コードに明示的な定義がない
  - 候補：パフォーマンステスト仕様書 / 非機能要件定義書

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - データ構造の記述（E-01, E-02に基づく）
- 0: 低リスク - エクスポート処理の記述（E-03, E-04に基づく）
- 0: 低リスク - インポート処理の記述（E-05〜E-07に基づく）
- 1: 中リスク - パフォーマンス要件（推測に基づく記述）

## 6) レビュアーチェックリスト（最小）
- [ ] IUserDataProfileTemplateの各フィールドが正しく記載されているか
- [ ] isUserDataProfileTemplate()の検証条件が正しいか
- [ ] applyProfileTemplate()の各リソース適用順序が正しいか
- [ ] エラーケースの対応が実装と一致しているか
- [ ] PROFILE_EXTENSION（.code-profile）が最新か
